classdef color
    properties
        R, G, B
	end
	methods (Static)
		function cm = map(keyColors, n)
			cm = NaN(n, 3);
			
			keyIndexes = round(linspace(1, n, size(keyColors, 1)));
			
			for c = 1:size(keyColors, 1)-1
				cm(keyIndexes(c):keyIndexes(c+1), :) = color.scale(keyColors(c,:), keyColors(c+1,:), keyIndexes(c+1)-keyIndexes(c)+1);
			end
		
		end
		function cm = scale(c1, c2, n)
			cm = NaN(n, 3);
			
			for i = 1:3
				cm(:,i) = linspace(c1(i), c2(i), n);
			end 
		end
	end
	
    methods
        function c = color(r, g, b)
            c.R = r;
            c.G = g;
            c.B = b;
        end
        function c = rgb(c, shade)
            if ~exist('shade', 'var')
                shade = 0;
            elseif max(abs(shade)) > 1
                error("shade must be comprised between -1 and 1");
            end

            base1 = [c.R c.G c.B];
			if ~isscalar(shade)
				shade = reshape(shade, numel(shade), 1);
				shade = repmat(shade, 1, 3);

				base1 = repmat(base1, size(shade, 1), 1);
			end

			base2 = ones(size(shade));
			base2(shade < 0) = 0;

			shade(shade < 0) = -shade(shade < 0);

            c = shade .* base2 + (1 - shade) .* base1;

			% c = [[c.R]', [c.G]', [c.B]'];
		end
	end
	
    enumeration
		white			(1.00, 1.00, 1.00)
		light_grey		(0.95, 0.95, 0.95)
		grey			(0.75, 0.75, 0.75)
		dark_grey		(0.50, 0.50, 0.50)
		darker_grey		(0.30, 0.30, 0.30)
		black			(0.20, 0.20, 0.20)
		
		lighter_green	(0.70, 1.00, 0.64)
		light_green		(0.38, 0.85, 0.30)
        green			(0.47, 0.67, 0.19)
		dark_green		(0.00, 0.23, 0.07)
		
		lighter_blue	(0.75, 0.87, 0.94)
		light_blue		(0.50, 0.73, 0.87)
		blue			(0.00, 0.45, 0.74)
		dark_blue		(0.04, 0.13, 0.36)
		
		lighter_orange	(0.97, 0.73, 0.60)
		light_orange	(0.93, 0.46, 0.20)
		orange			(0.85, 0.32, 0.10)
		dark_orange		(0.75, 0.22, 0.00)
		
		light_red		(1.00, 0.70, 0.70)
		red				(0.89, 0.02, 0.07)
		dark_red		(0.60, 0.00, 0.00)
		
		yellow			(0.92, 0.69, 0.12)
		purple			(0.49, 0.18, 0.55)
		
		magenta			(0.90, 0.29, 0.59)
    end
end
